# Features
* check_settings_integrity() won't run SQL queries on front-end and in the back-end it will run only once and only in specific circumstances
* Option to create database dump was removed as it was not working correctly. Please use additional plugins to do this (eg https://wordpress.org/plugins/adminer/ )
* We added ability to add language information to duplicated content, when WPML_COMPATIBILITY_TEST_MODE is defined

# Fixes
* Ajax now "knows" language of page which made a ajax call
* Category hierarchy and pages hierarchy are now synchronised during translation
* Compatibility with WordPress 3.9 - WPML plugins were adjusted to use WPDB class in correct way, no direct usages of mysql_** functions
* Corrupted settings when no language in array - fixing this now doesn't end with pages missing
* Custom Post Types when was set not to be translated was also not displayed, now it's fixed
* Filtered language doesn't remain as 'current value' on the wpml taxonomy page - this is also fixed
* Fixed compatibility issue with PHP versions < 5.3.6: constants DEBUG_BACKTRACE_PROVIDE_OBJECT and DEBUG_BACKTRACE_IGNORE_ARGS does not exist before this version, causing a PHP notice message
* Fixed compatibility with CRED/Views (404, rewrite_rules_filter)
* Fixed filtering wp_query with tax_query element
* Fixed issue when a showing paginated subqueries in home page (in non default language)
* Fixed Korean locale in .mo file name
* Fixed monthly archive page, now it shows language switcher with correct urls
* Fixed not hidden spinner after re-install languages
* Fixed Notice message when duplicating posts using Translation Management
* Fixed PHP Fatal error: Cannot use object of type WP_Error as array
* Fixed potential bug caused by redeclaration of icl_js_escape() function
* Fixed problem with redirecting to wrong page with the same slug in different language after upgrade to WP3.9
* Fixed problem with Sticky Links and Custom Taxonomies
* Fixed problems with missing taxonomies configuration from wpml-config.xml file
* Fixed saving setting for custom fields translation
* Fixed typos when calling in some places _() instead of __()
* Fixed WP 3.9 compatibility issues related to language switcher widget
* Fixed wrong links to attachments in image galleries
* Gallery was not displayed on root home page, this is fixed now
* Handled timeout error message when fixing languages table
* Home url not converted in current language when using different domains per language and WP in a folder
* In some circumstance translated posts statuses doesn't get synchronized after publishing a post: fixed now
* In some server configuration we were getting either a 404 error or a redirect loop
* Information about hidden languages was displayed duplicated and doubled after every page refresh
* is_ajax() function is now deprecated and replaced by wpml_is_ajax() - **plugins and themes developers**: make sure you're updating your code!
* Made SitePress::slug_template only work for taxonomies
* Many fixes in caching data what results in better site performance
* MENU (Automatically add new top-level pages to this menu) option was not synchronised
* Option to translate custom posts slugs is now hidden when it is no set to translate them
* Parent pages can be now changed or removed
* Removed conflict between front page which ID was same as ID of actually displayed taxonomy archive page
* Removed duplicated entries in hidden languages list
* Removed PHP Notice on secondary language front page
* Removed warning in inc/absolute-links/absolute-links.php
* Root page can work now with parameters
* Static front page is not loosing now custom page template on translations when paged
* Taxonomy @lang suffixes wasn't hidden always when it was necessary, now this is also fixed
* The "Connect translation" feature now works also when the WYSIWYG is not shown
* Update posts using element_id instead of translation_id
* Updated links to wpml.org
* We added links to String Translation if there are labels or urls that needs to be translated, when running menu synchronization
* We make use of debug_backtrace in some places: wherever it is possible (and depending on used PHP version), we've reduced the impact of this call by limiting the number of retrieved frames, or the complexity of the retrieved data
* When you try to delete an item from untranslated menu, you saw PHP errors, now this is also fixed
* WP 3.9 compatibility issue: new version of WordPress doesn't automatically load dialog JS
* You can restore trashed translation when you tried to edit this